import asyncio
import socket
import os
import time
import sys
import ast

from enum import IntEnum

from pylog.pylogger import PyLogger

from datetime import datetime

from py_pli.pylib import VUnits, Measurements, GlobalVar
from predefined_tasks.common.helper import send_to_gc, mini_initialize_instrument, report_path, write_header_to_report
from py_pli.pyexception import UrpcFirmwareException
from pylog.pylogger import PyLogger
from meas_services.instrument import InstrumentService


import config_enum.scan_table_enum as scan_table_enum
import config_enum.excitationlight_selector_enum as els_enum
import config_enum.filter_module_slider_enum as fms_enum
import config_enum.bottom_light_director_enum as bld_enum
import config_enum.focus_mover_enum as fm_enum
import config_enum.platedoor_enum as pd_enum
import config_enum.detector_aperture_slider_enum as das_enum


# Constants
PATH, SCRIPT = os.path.split(__file__)
BASE_NAME = SCRIPT.split('.')[0]
ADJUSTMENT_PATH = '/home/pkiuser/.config/pyrunner/'

# Logging and Messages
logger = PyLogger.logger

# Mover
fm = VUnits.instance.hal.focusMover
st = VUnits.instance.hal.scan_table
pd = VUnits.instance.hal.plateDoor
fms = VUnits.instance.hal.filterModuleSlider
das1 = VUnits.instance.hal.detectorApertureSlider1

# Measurement
instrument_service = InstrumentService(hal=VUnits.instance.hal)
meas_unit = VUnits.instance.hal.measurementUnit


async def fm_change_test():
    # Scan Modules
    # Move to first module
    # Start timer
    # Delay for measurement
    # Move to second module and delay
    # Move to first module again and stop timer
    # repeat 10 times and return mean of change time

async def seq_meas_test(id_1, id_2):
    # scan modules
    # start timer
    # move ti id_1
    # measure
    # move to id_2
    # measure
    # move to id_1 again 
    # stop timer

## Low Level Functions

async def _pre_test():
    
    # DIRTY #

    msg = f"preparing Test Conditions "
    await send_to_gc(msg, False, False)

    try:
        await mini_initialize_instrument()
        msg = f"mini_initialize done"
        await send_to_gc(msg, False, False)
    except Exception as ex:
        msg = f"_pretest -> mini_initialize failed Exception: {ex}"
        await send_to_gc(msg, True, True)
        GlobalVar.set_stop_gc(True)

    await scan_table.Move(0,0)

    msg = f"preconditions ready"
    return (msg)


async def _get_signal(focus_height= 0, exc_time= 10, meas_time = 1000, relax = 0.2): 
    
    # DIRTY #

    # takes one measurement with
    # focus_height
    # exc_time
    # meas_time
    # and returns the second value (first value is somehow weird)

    # Focus Mover 
    await focus_mover.Move(focus_height)
   
    await Measurements.instance.FI_Meas.test_init_al_test(exc_time_ms = exc_time, measTime_ms = meas_time)
    await meas_unit.Set_PMT1_HV(True)
    samples = []
    try:
        for i in range (no_samples):
            _, signals = await Measurements.instance.asusMeas.execute_al_test()
            await asyncio.sleep(relax)
            # debug only: await send_to_gc(f"{signals[0]}", False, False)
            samples.append(signals[0])

    except Exception as ex:
        msg = f"_get_signal -> asusMeas execution failed {ex}"
        await send_to_gc(msg, True, True)
        GlobalVar.set_stop_gc(True)

    # Shut down
    try:
        await Measurements.instance.asusMeas.release()

    except Exception as ex:
        msg = f"_flash_meas -> asusMeas release failed {ex}"
        await send_to_gc(msg, True, True)
        GlobalVar.set_stop_gc(True)

    meas_unit.ClearOperations()

    return(samples[-1])
